import java.util.*;
class Info implements Comparable<Info>{
    int value,node;
    public Info(int value, int node){
        this.value = value;
        this.node = node;
    }
    public int compareTo(Info i){
        if(value != i.value) return value - i.value;
        return node - i.node;
    }

}
public class paths{
    static ArrayList<TreeSet<Info>> G;
    static long k;
    static int destination = -1;
    static void dfs(int u, int p){
        if(k == 0) {
            destination = u;
            return;
        }
        for(Info i : G.get(u)){
            if(i.node == p) continue;
            --k;
            dfs(i.node, u);
            if(destination != -1) return;
        }
    }
    public static void main(String[] args){
        Scanner in = new Scanner(System.in);
        int n = in.nextInt();
        k = in.nextLong();
        Info[] values = new Info[n+1];
        values[0] = new Info(-1,-1);
        G = new ArrayList<>();
        G.add(null);
        for(int i=1;i<=n;++i){
            int value = in.nextInt();
            values[i] = new Info(value, i);
            G.add(new TreeSet<>());
        }

        for(int i=0;i<n-1;++i){
            int u = in.nextInt(), v = in.nextInt();
            G.get(u).add(new Info(values[v].value, v));
            G.get(v).add(new Info(values[u].value, u));
        }
        Arrays.sort(values);
        int root = (int) ((k-1) / n + 1);
        root = values[root].node;
        k = (k % n != 0 ? k%n : n) - 1;
        dfs(root, -1);
        HashMap<Integer, Integer> predecessors = new HashMap<>();
        predecessors.put(root, root);
        ArrayDeque<Integer> dq = new ArrayDeque<>();
        dq.add(root);
        while(!dq.isEmpty()){
            int u = dq.pollFirst();
            for(Info i : G.get(u)){
                if(predecessors.containsKey(i.node)) continue;
                predecessors.put(i.node, u);
                dq.add(i.node);
            }
        }
        ArrayList<Integer> ans = new ArrayList<>();
        while(destination != predecessors.get(destination)){
            ans.add(destination);
            destination = predecessors.get(destination);
        }
        ans.add(root);
        for(int i = ans.size()-1; i>=0; --i){
            System.out.print(ans.get(i) + (i != 0 ? " " : "\n"));
        }
    }
}
