#include <bits/stdc++.h>
using namespace std;
using info = pair<int,int>;
using ll = long long;
map<int, set<info>> G;
ll k;
int destination = -1;
void dfs(int u, int p){
    if(!k) {
        destination = u;
        return;
    }
    for(auto &e : G[u]){
        auto [val, v] = e;
        if(v == p) continue;
        --k;
        dfs(v, u);
        if (destination != -1) return;
    }
}
int main(){
    ios::sync_with_stdio(0);
    cin.tie(0);
    int n;
    cin>>n>>k;
    vector<info> values(n+1);
    for(int i=1;i<=n;++i){
        int v;
        cin>>v;
        values[i] = {v, i};
    }
    // G = map<int, set<info>>();
    for(int i=0;i<n-1;++i){
        int u,v;
        cin>>u>>v;
        G[u].insert({values[v].first, v});
        G[v].insert({values[u].first, u});
    }
    sort(values.begin()+1,values.end());
    int root = (k-1) / n + 1;
    root = values[root].second;
    k = (k%n ? k%n : n) - 1;
    dfs(root, -1);
    map<int,int> predecessors;
    predecessors[root] = root;
    deque<int> dq;
    dq.push_back(root);
    while(!dq.empty()){
        auto u = dq.front();
        dq.pop_front();
        for(auto &e : G[u]) {
            auto [val, v] = e;
            if(predecessors.count(v)) continue;
            predecessors[v] = u;
            dq.push_back(v);
        }
    }
    vector<int> ans;
    while(destination != predecessors[destination]) {
        ans.push_back(destination);
        destination = predecessors[destination];
    }
    ans.push_back(root);
    for(int i=ans.size()-1;i>=0;--i) {
        cout<<ans[i]<<(i?' ':'\n');
    }
    return 0;
}
