import java.util.*;
class SegmentTree {
    long[] segtree = new long[300000];
    int start,n;
    private void point_update(int i, long v){
        i += start;
        while(i > 0) {
            segtree[i] += v;
            i >>= 1;
        }
    }
    public SegmentTree(String s){
        n = s.length();
        start = Integer.highestOneBit(n);
        if(start != n) start <<= 1;

        long sum = 0;
        for(int i=start;i<start+n;++i){
            long diff = s.charAt(i-start) - 97 - ((sum%26+26)%26);
            segtree[i] = diff;
            sum += diff;
        }
        for(int i=start-1;i>0;--i)
            segtree[i] = segtree[i<<1] + segtree[(i<<1)+1];
    }
    public long query(int right){
        right += start;
        int left = start;
        long ans = 0;
        while(left <= right){
            if(left%2==1)
                ans += segtree[left++];
            if(right%2==0)
                ans += segtree[right--];
            left >>= 1; right >>= 1;
        }
        return (ans%26+26)%26;
    }
    public void update(int a, int b, boolean d){
        point_update(a, d ? 1 : -1);
        if(b+1<n)
            point_update(b+1, d ? -1 : 1);
    }
}
public class letter_hard{
    public static void main(String[] args){
        Scanner in = new Scanner(System.in);
        int q = in.nextInt();
        String s = in.next();
        SegmentTree st = new SegmentTree(s);
        for(int i=0;i<q;++i){
            boolean T = in.nextInt() == 1;
            if(T) {
                int k = in.nextInt();
                long v = st.query(k);
                System.out.println( (char)(v+97) );
            } else {
                int a = in.nextInt(), b = in.nextInt();
                boolean d = in.nextInt() == 1;
                st.update(a,b,d);
            }
        }
    }
}
