#include <bits/stdc++.h>
using namespace std;
using ll = long long;
class SegmentTree {
    ll segtree[300000];
    int start;
    int n;
    void point_update(int i, int v) {
        i += start;
        while (i) {
            segtree[i] += v;
            i >>= 1;
        }
    }
public:
    SegmentTree(string &s) {
        memset(segtree, 0, sizeof(segtree));
        n = s.size();
        start = 1 << (31 - __builtin_clz(s.size()));
        if(start != n) start <<= 1;


        ll sum = 0;
        for (int i=start;i<start+n;++i) {
            ll diff = s[i-start]-97 - (sum%26+26)%26;
            segtree[i] = diff;
            sum += diff;
        }
        for (int i=start-1;i>0;--i)
            segtree[i] = segtree[i<<1] + segtree[(i<<1)+1];
    }
    ll query(int right) {
        right += start;
        int left = start;
        ll ans = 0;
        while (left <= right) {
            if (left&1)
                ans += segtree[left++];
            if (!(right&1))
                ans += segtree[right--];
            left >>= 1; right >>= 1;
        }
        return (ans%26+26)%26;
    }

    void update(int a, int b, bool d) {
        point_update(a, d ? 1 : -1);
        if (b + 1 < n)
            point_update(b+1, d ? -1 : 1);
    }
};
int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);
    int q;
    cin>>q;
    string s;
    cin>>s;
    SegmentTree *st = new SegmentTree(s);
    for (int i=0;i<q;++i) {
        int T;
        cin>>T;
        if (T) {
            int k;
            cin>>k;
            ll v = st->query(k);
            cout<<(char)(v%26+97)<<'\n';
        } else {
            int a,b,d;
            cin>>a>>b>>d;
            st->update(a,b,d);
        }
    }
    return 0;
}
