import java.util.*;
class Point{
    double x,y;
    public Point(double x, double y){
        this.x = x;
        this.y = y;
    }
    public double distance(Point p){
        return Math.sqrt((x-p.x) * (x-p.x) + (y-p.y) * (y-p.y));
    }
    public Point vector(Point p){
        return new Point(p.x - x, p.y - y);
    }
}
public class delights{
    static double cross(Point v1, Point v2){
        return v1.x * v2.y - v1.y * v2.x;
    }
    public static void main(String[] args){
        Scanner in = new Scanner(System.in);
        int n = in.nextInt();
        Point[] points = new Point[n];
        for(int i=0;i<n;++i)
            points[i] = new Point(in.nextDouble(), in.nextDouble());
        ArrayList<Double> cross_products = new ArrayList<>();
        ArrayList<Double> side_lengths = new ArrayList<>();
        for(int i=0;i<n;++i){
            Point p1 = points[i];
            Point p2 = points[(i+1)%n];
            Point p3 = points[(i+2)%n];
            side_lengths.add(p1.distance(p2));
            cross_products.add(cross(p1.vector(p2), p2.vector(p3)));
        }
        Collections.sort(cross_products);
        Collections.sort(side_lengths);
        boolean regular = cross_products.get(n-1) - cross_products.get(0) <= 1e-4 && side_lengths.get(n-1) - side_lengths.get(0) <= 1e-4;
        System.out.println(regular ? "Yay!" : ":(");
    }
}
