#include <bits/stdc++.h>
#define x first
#define y second
using namespace std;
using point = pair<double,double>;
double cross(point v1, point v2) {
    return v1.x * v2.y - v1.y * v2.x;
}
double distance(point p1, point p2) {
    return sqrt((p2.x-p1.x) * (p2.x-p1.x) + (p2.y-p1.y) * (p2.y-p1.y));
}
int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);
    int n;
    cin>>n;
    point points[n];
    for (int i=0;i<n;++i) {
        double a,b;
        cin>>a>>b;
        points[i] = {a,b};
    }
    vector<double> cross_products;
    vector<double> side_lengths;
    for (int i=0;i<n;++i) {
        point p1 = points[i];
        point p2 = points[(i+1)%n];
        point p3 = points[(i+2)%n];
        side_lengths.push_back(distance(p1,p2));
        cross_products.push_back(cross({p2.x-p1.x,p2.y-p1.y},{p3.x-p2.x,p3.y-p2.y}));
    }
    sort(cross_products.begin(),cross_products.end());
    sort(side_lengths.begin(),side_lengths.end()); 
    bool regular = cross_products[n-1] - cross_products[0] <= 1e-4 && side_lengths[n-1] - side_lengths[0] <= 1e-4;
    cout<<(regular ? "Yay!" : ":(")<<'\n';
}
